<?php

include_once 'conexao.php'; // Arquivo com a conexão ao banco de dados

class ModeloInteracoesNaPlataforma
{
    // Função para adicionar uma nova interação na plataforma
    static public function mdlAdicionarInteracao($dados)
    {
        // Preparar a consulta de inserção
        $stmt = Conexao::conectar()->prepare("INSERT INTO interacoesnaplataforma (operacao, dataCadastro) VALUES (:operacao, :dataCadastro)");

        // Data e hora da operação
        $dataCadastro = date("Y-m-d H:i:s"); 

        // Vincular os parâmetros
        $stmt->bindParam(":operacao", $dados["operacao"], PDO::PARAM_STR);
        $stmt->bindParam(":dataCadastro", $dataCadastro, PDO::PARAM_STR);

        // Executar a consulta e verificar se ocorreu com sucesso
        if ($stmt->execute()) {
            return "ok";
        } else {
            // Retorna a mensagem de erro, se houver falha
            $errorInfo = $stmt->errorInfo();
            return $errorInfo[2];
        }
    }

    // Função para buscar todas as interações na plataforma
    static public function mdlListarInteracoes()
    {
        // Preparar a consulta de seleção
        $stmt = Conexao::conectar()->prepare("SELECT * FROM interacoesnaplataforma");

        // Executar a consulta
        $stmt->execute();

        // Retornar todos os registros como um array associativo
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    static public function mdlMostrarTodasOperacoesComLikeUsandoDescricaoDaOperacao($operacao) {

        $resultado = array(); 
    
        // Preparar a instrução SQL com LIKE
        $stmt = Conexao::conectar()->prepare("SELECT * FROM interacoesnaplataforma WHERE operacao = :operacao");
        $stmt->bindParam(":operacao", $operacao, PDO::PARAM_STR);
        
        // Executa a consulta e retorna os resultados
        $stmt->execute();
        $resultado = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        return $resultado;
    }
    

    // Função para buscar interações por tipo de operação
    static public function mdlBuscarInteracoesPorOperacao($operacao)
    {
        // Preparar a consulta de seleção por operação
        $stmt = Conexao::conectar()->prepare("SELECT * FROM interacoesnaplataforma WHERE operacao = :operacao");

        // Vincular o parâmetro
        $stmt->bindParam(":operacao", $operacao, PDO::PARAM_STR);

        // Executar a consulta
        $stmt->execute();

        // Retornar os resultados como um array associativo
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
?>
